document.addEventListener("DOMContentLoaded", function() {

    function setupCopyToClipboard(containerId, buttonId) {
        const contenedorTexto = document.getElementById(containerId);
        const botonCopiar = document.getElementById(buttonId);

        if (contenedorTexto && botonCopiar) {
            botonCopiar.addEventListener("click", function() {
                const textoACopiar = contenedorTexto.innerText;
                
                // Intenta usar la API moderna de Portapapeles
                if (navigator.clipboard && window.isSecureContext) {
                    navigator.clipboard.writeText(textoACopiar)
                        .then(() => {
                            alert("¡Texto copiado al portapapeles!");
                        })
                        .catch(err => {
                            console.error("Error al copiar con navigator.clipboard:", err);
                            // Si falla, usa el método de fallback
                            copyUsingExecCommand(textoACopiar);
                        });
                } else {
                    // Fallback para entornos no seguros o navegadores antiguos
                    copyUsingExecCommand(textoACopiar);
                }
            });
        }
    }

    // Función de fallback usando document.execCommand
    function copyUsingExecCommand(text) {
        const tempTextArea = document.createElement("textarea");
        tempTextArea.value = text;
        document.body.appendChild(tempTextArea);
        tempTextArea.select();
        try {
            document.execCommand('copy');
            alert("¡Texto copiado al portapapeles!");
        } catch (err) {
            console.error("Error al copiar con execCommand:", err);
            alert("Hubo un error al intentar copiar el texto.");
        } finally {
            document.body.removeChild(tempTextArea);
        }
    }

    // Configura los botones
    setupCopyToClipboard("contenedor-texto", "boton-copiar");
    
});