<?php
// ====================================================================
// PARÁMETROS DE CONEXIÓN A LA BASE DE DATOS
// ¡AJUSTA ESTOS VALORES!
// ====================================================================
define('DB_SERVER', 'localhost');
define('DB_USERNAME', 'root'); 
define('DB_PASSWORD', ''); 
define('DB_NAME', 'archivos'); 

// 1. CONEXIÓN A LA BASE DE DATOS
$conn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);
if ($conn->connect_error) {
    // Si falla la conexión, mostramos un error fatal
    die("Error de conexión a la base de datos: " . $conn->connect_error);
}

// ====================================================================
// PARÁMETROS DE PAGINACIÓN Y CÁLCULOS
// ====================================================================

$registros_por_pagina = 7; 
$pagina_actual = isset($_GET['pagina']) && filter_var($_GET['pagina'], FILTER_VALIDATE_INT) > 0 ? (int)$_GET['pagina'] : 1;
$offset = ($pagina_actual - 1) * $registros_por_pagina;

// CÁLCULO DEL TOTAL DE PÁGINAS
$sql_total = "SELECT COUNT(*) AS total FROM detalles";
$resultado_total = $conn->query($sql_total);
$fila_total = $resultado_total->fetch_assoc();
$total_registros = (int)$fila_total['total'];
$total_paginas = ceil($total_registros / $registros_por_pagina);

// Ajuste si la página solicitada es mayor que el total (y hay registros)
if ($total_paginas > 0 && $pagina_actual > $total_paginas) {
    $pagina_actual = $total_paginas;
    $offset = ($pagina_actual - 1) * $registros_por_pagina;
}

// ====================================================================
// OBTENER LOS REGISTROS PARA LA PÁGINA ACTUAL
// ====================================================================

$sql_registros = "SELECT nombre FROM detalles ORDER BY numero DESC LIMIT ? OFFSET ?";
$nombres_archivos = [];

if ($stmt = $conn->prepare($sql_registros)) {
    $stmt->bind_param("ii", $registros_por_pagina, $offset);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $nombres_archivos[] = htmlspecialchars($row['nombre']);
    }

    $stmt->close();
} else {
    $error_consulta = "Error al preparar la consulta: " . $conn->error;
}

// CERRAR CONEXIÓN
$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ramiro G. Glez.</title>
    <link rel="apple-touch-icon" sizes="180x180" href="./Imagenes/Favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="./Imagenes/Favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./Imagenes/Favicon/favicon-16x16.png">
    <link rel="manifest" href="./Imagenes/Favicon/site.webmanifest">
    <link rel="stylesheet" href="./Styles/tema.css">
</head>
<body>
    <header>
        <h1>Lista de Registros de Archivos</h1>
    <main>
        <ol>
            <?php if (!empty($nombres_archivos)): ?>
                <?php foreach ($nombres_archivos as $nombre): ?>
                    <li><?php echo $nombre; ?></li>
                <?php endforeach; ?>
            <?php elseif (isset($error_consulta)): ?>
                <li><strong style="color: red;"><?php echo $error_consulta; ?></strong></li>
            <?php else: ?>
                <li><em>No hay registros para mostrar.</em></li>
            <?php endif; ?>
            
            <li><a href="./registro.php">+ Agregar Nuevo Registro</a></li>
        </ol>
    </main>

    <section>
        <?php if ($total_paginas > 1): ?>
            <ul class="pagination">
                
                <?php if ($pagina_actual > 1): ?>
                    <li><a href="?pagina=<?php echo $pagina_actual - 1; ?>">Retroceder</a></li>
                <?php else: ?>
                    <li class="disabled">Retroceder</li>
                <?php endif; ?>

                <?php 
                $rango_paginas = 2;
                $inicio = max(1, $pagina_actual - $rango_paginas);
                $fin = min($total_paginas, $pagina_actual + $rango_paginas);

                for ($i = $inicio; $i <= $fin; $i++): 
                ?>
                    <li class="<?php echo ($i == $pagina_actual) ? 'active' : ''; ?>">
                        <?php if ($i == $pagina_actual): ?>
                            <?php echo $i; ?>
                        <?php else: ?>
                            <a href="?pagina=<?php echo $i; ?>"><?php echo $i; ?></a>
                        <?php endif; ?>
                    </li>
                <?php endfor; ?>

                <?php if ($pagina_actual < $total_paginas): ?>
                    <li><a href="?pagina=<?php echo $pagina_actual + 1; ?>">Avanzar</a></li>
                <?php else: ?>
                    <li class="disabled">Avanzar</li>
                <?php endif; ?>

            </ul>
        <?php endif; ?>
    </section>

    <footer>
        <small>&copy;<a href="../index.html">TFH</a></small>
    </footer>
</body>
</html>