<?php

// ====================================================================
// PARÁMETROS DE CONEXIÓN A LA BASE DE DATOS
// ¡AJUSTA ESTOS VALORES A LOS DE TU SERVIDOR!
// ====================================================================
define('DB_SERVER', 'localhost');
define('DB_USERNAME', 'root'); // E.g., root
define('DB_PASSWORD', ''); // E.g., '' (vacío para XAMPP)
define('DB_NAME', 'archivos'); // El nombre de tu base de datos

// ====================================================================
// 1. INICIALIZAR LA CONEXIÓN A LA BASE DE DATOS
// ====================================================================
$conn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);

// Verificar la conexión
if ($conn->connect_error) {
    // Si falla la conexión, mostramos un error y terminamos el script
    die("Error de conexión a la base de datos: " . $conn->connect_error);
}

// ====================================================================
// 2. PROCESAR EL FORMULARIO (ASUMIENDO MÉTODO POST PARA SEGURIDAD)
// ====================================================================
// *NOTA*: Si mantuviste el 'method="get"' original, usa $_GET en su lugar.
if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET['nombre_archivo'])) {

    // Obtener y sanitizar el dato del formulario
    $nombreArchivo = trim($_GET['nombre_archivo']);
    
    // Asignar un valor para el campo 'hash' (aquí lo dejamos vacío)
    $hash = ''; 

    // ================================================================
    // 3. VALIDACIÓN (BÁSICA)
    // ================================================================
    if (empty($nombreArchivo)) {
        echo "<h2>Error de Validación ⚠️</h2>";
        echo "<p>El nombre del archivo no puede estar vacío.</p>";
        // Cerrar la conexión y terminar
        $conn->close();
        exit();
    }
    
    // ================================================================
    // 4. PREPARAR Y EJECUTAR LA CONSULTA SEGURA (Sentencias Preparadas)
    // ================================================================
    // Usamos sentencias preparadas para prevenir ataques de Inyección SQL.
    $sql = "INSERT INTO detalles (nombre, hash) VALUES (?, ?)";

    if ($stmt = $conn->prepare($sql)) {
        // Enlazar las variables a los parámetros de la sentencia preparada
        // 's' significa string (cadena de texto)
        $stmt->bind_param("ss", $nombreArchivo_param, $hash_param);
        
        // Asignar los valores a los parámetros
        $nombreArchivo_param = $nombreArchivo;
        $hash_param = $hash; 
        
        // Intentar ejecutar la sentencia
        if ($stmt->execute()) {
            // Redirigir al usuario a una página de éxito (buena práctica)
            // header("Location: exito.html");
            echo "<h2>✅ ¡Registro Guardado con Éxito!</h2>";
            echo "<p>Se insertó el nombre: <strong>" . $nombreArchivo . "</strong> en la base de datos.</p>";
        } else {
            echo "<h2>Error al Guardar Registro ❌</h2>";
            echo "<p>Ocurrió un error al ejecutar la consulta: " . $stmt->error . "</p>";
        }

        // Cerrar la sentencia
        $stmt->close();
    } else {
        echo "<h2>Error al Preparar Consulta ❌</h2>";
        echo "<p>Error: " . $conn->error . "</p>";
    }

} /*else {
    // Manejar el caso donde no se envió el formulario
    echo "<h2>Acceso Inválido 🛑</h2>";
    echo "<p>Por favor, envíe el formulario correctamente.</p>";
}*/

// ====================================================================
// 5. CERRAR LA CONEXIÓN A LA BASE DE DATOS
// ====================================================================
$conn->close();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ramiro G. Glez.</title>
    <link rel="apple-touch-icon" sizes="180x180" href="./Imagenes/Favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="./Imagenes/Favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./Imagenes/Favicon/favicon-16x16.png">
    <link rel="manifest" href="./Imagenes/Favicon/site.webmanifest">
    <link rel="stylesheet" href="./Styles/tema.css">
</head>
<body>
    <header><h1>Nuevo Archivo</h1></header>
    <main>
        <ol>
            <li>
                <form action="registro.php" method="get">
                    <input required placeholder="Nombre del Archivo" name="nombre_archivo">
                    <br>
                    <input type="submit" value="Guardar Registro">
                </form>
            </li>
            <li><a href="index.php">Retroceder</a></li>
        </ol>
    </main>
</body>
</html>