<?php
// dir_navigator.php
// Este script maneja la creación de la vista HTML y la eliminación de archivos.

// Configuración
$current_dir = __DIR__;
$output_filename = 'index.html';
$ignored_items = ['.', '..','view.php','index.html'];

// --- FUNCIÓN DE ELIMINACIÓN ---
if (isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['filename'])) {
    $file_to_delete = basename($_POST['filename']); // Solo el nombre del archivo por seguridad
    $full_path = $current_dir . '/' . $file_to_delete;

    if (file_exists($full_path) && !in_array($file_to_delete, $ignored_items) && $file_to_delete !== 'view.php') {
        if (unlink($full_path)) {
            echo json_encode(['success' => true, 'message' => "Archivo '{$file_to_delete}' eliminado con éxito."]);
        } else {
            echo json_encode(['success' => false, 'message' => "Error: No se pudo eliminar el archivo. Verifique permisos."]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => "Error: Archivo no encontrado o no autorizado para eliminar."]);
    }
    exit;
}

// --- FUNCIÓN DE GENERACIÓN DE VISTA ---
function generate_directory_view($current_dir, $output_filename, $ignored_items) {
    // 1. Lógica para leer el directorio y generar los enlaces
    $items = scandir($current_dir);
    $links_html = "";

    if ($items !== false) {
        foreach ($items as $item) {
            if (in_array($item, $ignored_items)) {
                continue;
            }

            $is_directory = is_dir($current_dir . '/' . $item);
            $icon = $is_directory ? '<i class="fas fa-folder"></i>' : '<i class="fas fa-file"></i>';
            $button_class = $is_directory ? 'dir-button directory' : 'dir-button file';

            // El botón de eliminar solo se agrega a los archivos
            $delete_button = '';
            if (!$is_directory) {
                // Usamos la función de JavaScript 'deleteFile' en el onclick (ahora implementada con delegación en JS)
                $delete_button = '<button class="delete-btn" data-filename="' . htmlspecialchars($item) . '"><i class="fas fa-trash-alt"></i></button>';
            }

            $links_html .= '
            <div class="item-container">
                <a href="' . htmlspecialchars($item) . '" target="_blank" class="' . $button_class . '">
                    ' . $icon . '
                    <span>' . htmlspecialchars($item) . '</span>
                </a>
                ' . $delete_button . '
            </div>';
        }
    } else {
        $links_html = '<p class="error-msg">Error al leer el directorio.</p>';
    }

    // Nombre de la carpeta actual
    $current_dir_name = basename($current_dir);

    // 2. Contenido HTML completo
    // NOTA: Se han insertado las líneas de <link> solicitadas aquí
    $html_content = <<<HTML
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Navegador de Directorio | {$current_dir_name}</title>
    <link rel="apple-touch-icon" sizes="180x180" href="Archivos/Imagenes/Favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="Archivos/Imagenes/Favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="Archivos/Imagenes/Favicon/favicon-16x16.png">
    <link rel="manifest" href="Archivos/Imagenes/Favicon/site.webmanifest">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; color: #333; margin: 0; padding: 20px; text-align: center; }
        .container { max-width: 900px; margin: 40px auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1); }
        h1 { color: #2c3e50; margin-bottom: 30px; }
        .controls { margin-bottom: 30px; display: flex; justify-content: center; gap: 15px; }
        .action-btn { display: inline-block; padding: 10px 20px; text-decoration: none; border-radius: 5px; font-weight: bold; transition: background-color 0.3s; border: none; cursor: pointer; }
        .index-btn { background-color: #3498db; color: white; }
        .refresh-btn { background-color: #2ecc71; color: white; }
        .index-btn:hover { background-color: #2980b9; }
        .refresh-btn:hover { background-color: #27ae60; }
        
        .grid-container { display: grid; grid-template-columns: repeat(auto-fill, minmax(250px, 1fr)); gap: 20px; }
        
        .item-container { display: flex; align-items: center; justify-content: space-between; border: 1px solid #ddd; border-radius: 8px; overflow: hidden; }
        .dir-button { flex-grow: 1; display: flex; align-items: center; padding: 15px; text-align: left; text-decoration: none; font-size: 1em; font-weight: bold; transition: background-color 0.2s; }
        .dir-button i { margin-right: 10px; font-size: 1.2em; }
        
        .directory { background-color: #ecf0f1; color: #2c3e50; }
        .directory i { color: #f1c40f; }
        .file { background-color: #e8f5e9; color: #27ae60; }
        .file i { color: #27ae60; }
        
        .delete-btn { background-color: #e74c3c; color: white; border: none; padding: 15px; cursor: pointer; transition: background-color 0.2s; }
        .delete-btn:hover { background-color: #c0392b; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Explorador de Directorio: /.../{$current_dir_name}</h1>
        
        <div class="controls">
            <a href="/index.html" class="action-btn index-btn">
                <i class="fas fa-home"></i> Volver a Index Principal
            </a>
            <button id="refresh-view" class="action-btn refresh-btn">
                <i class="fas fa-sync-alt"></i> Refrescar/Crear Menú
            </button>
        </div>
        
        <hr>

        <div class="grid-container">
            {$links_html}
        </div>
    </div>
    
    <script>
        // Función de JavaScript para eliminar archivo
        function deleteFile(fileName) {
            if (!confirm('¿CONFIRMACIÓN DE ELIMINACIÓN CRÍTICA: Estás seguro de eliminar ' + fileName + '?')) {
                return;
            }

            // Llamada AJAX al mismo script PHP
            $.ajax({
                url: 'view.php', 
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'delete',
                    filename: fileName
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.message);
                        // Recargar la vista después de una eliminación exitosa
                        window.location.href = '{$output_filename}'; 
                    } else {
                        alert('ERROR DE PROTOCOLO: ' + response.message);
                    }
                },
                error: function() {
                    alert('ERROR DE CONEXIÓN con el servidor.');
                }
            });
        }
        
        // Manejar el clic en los botones de eliminar y refrescar
        $(document).ready(function() {
            // Asigna la función de eliminar a los botones dinámicamente
            // Nota: Se recomienda delegación para elementos creados dinámicamente, 
            // pero el código original ya los incluye en el HTML generado, por lo que este enfoque directo está bien.
            $('.delete-btn').on('click', function() {
                deleteFile($(this).data('filename'));
            });

            // Botón Refrescar/Crear: Simplemente redirige para regenerar el archivo
            $('#refresh-view').on('click', function() {
                // Redirige al script PHP, que lo recreará y redirigirá al HTML
                window.location.href = 'view.php'; 
            });
        });
    </script>
</body>
</html>
HTML;
    
    // 3. Escribir el contenido al archivo
    if (file_put_contents($output_filename, $html_content) === false) {
        die("Error: No se pudo escribir el archivo $output_filename. Verifica los permisos de la carpeta.");
    }
}

// Generar la vista y redirigir
generate_directory_view($current_dir, $output_filename, $ignored_items);

// 4. Redirigir al archivo generado
header("Location: " . $output_filename);
exit;
?>